	title	'NIOSA.ASM'
;/***********************************************************************/
;/*									*/
;/*			N I O S A . A S M				*/
;/*			-----------------				*/
;/*									*/
;/*	Copyright (C) 1988 Digital Research Inc. All rights		*/
;/*	reserved. The Software Code contained in this listing is	*/
;/*	proprietary to Digital Research Inc., Monterey,			*/
;/*	California, and is covered by U.S. and other copyright		*/
;/*	protection. Unauthorized copying, adaption, distribution,	*/
;/*	use or display is prohibited and may be subject to civil	*/
;/*	and criminal penalties. Disclosure to others is			*/
;/*	prohibited. For the terms and conditions of software use,	*/
;/*	refer to the appropriate Digital Research Licence		*/
;/*	Agreement.							*/
;/*									*/
;/***********************************************************************/
;/*									*/
;/*	Sample NIOS for several popular ARCNET cards for IBM PCs	*/
;/*	Note:	This is only the startup module, most actual code	*/
;/*		is contained in NIOS.C (written in Turbo C)		*/
;/*									*/
;/*	Written by:	JW, Digital Research EDC, Hungerford, GB	*/
;/*									*/
;/*	Date	   Who  Modification					*/
;/*	---------  ---	--------------------------------------------	*/
;/*	05-Dec-88  JW	Derived TASM sources from earlier RASM source	*/
;/*	27-Jun-89  JW	add another input line driver			*/
;/*	05-Aug-89  JW	dispatch if DRL != 0000h			*/
;/*									*/
;/*	To assemble:	tasm /ml niosa					*/
;/*									*/
;/***********************************************************************/

	include	i:drmacros.equ		; include our standard equates

CGROUP	group	_TEXT			; define code group
DGROUP	group	_DATA			; define data group

;NUM_I_LDCB	equ	2		; # of input line drivers
					; Note: defined via /D option!
NUM_O_LDCB	equ	1		; # of output line drivers

RCB_LDNUM	equ	byte ptr 20	; line driver number in RCB structure

;	The following three equates are hardware specific:

INT_OFF		equ	8		; 1st hardware int vector on PC
TMR_LVL		equ	0		; IRQ0 = timer
COM_LVL		equ	2		; IRQ2 = network board

;	Concurrent DOS dispatcher ready list in SYSDAT

drl		equ	ds:word ptr [006ch]	; DRL in SYSDAT

;	Some CDOS XM & CDOS 386 SYSDAT equates

MDUL		equ	0058h
XIOS_MFL	equ	00E2h


_TEXT	segment	public 'CODE'		; define Turbo C compatible code seg

	extrn	NINIT:near		; global NIOS initialization

	extrn	XIN_INIT:near		; network init pointer
	extrn	XIN:near		; rcvmsg driver
	extrn	XOUT:near		; send driver

	extrn	COM_INT:near		; hardware int handler
	extrn	TMR_INT:near		; timer int handler

	public	__BDOS			; CDOS BDOS calls
	public	__SUPIF			; CDOS BDOS calls

	public	V386_CHK		; test if CDOS 386
	public	V386_PTR		; return CDOS 386 paged memory block
	public	IO_MEM_ALLOC		; allocate segment memory
	public	INSERT_MFL		; insert entry into MFL

	public	MKPTR			; combine offset/seg => far pointer
	public	FARMOVE			; perform inter-segment move
	public	INT_INIT		; setup interrupt vectors
	public	FLAGSET			; set system flag
	public	MEMSET			; block-fill memory block

	public	LXLSH@			; long shift left

niosds		dw	seg niosdat	; data segment of NIOS
disp_addr	dd	i_com_iret	; address of OS dispatcher
disp_off	equ	word ptr disp_addr
disp_seg	equ	disp_off+2
i_tmr_ptr	label	dword		; address of XIOS timer handler
i_tmr_off	dw	0
i_tmr_seg	dw	0

	Assume	CS:CGROUP, DS:DGROUP, SS:DGROUP, ES:Nothing


__BDOS:
;------
	push	bp
	mov	bp,sp

	mov	cl,6[bp]		; get BDOS function number
	mov	dx,4[bp]		; get BDOS parameter
	push	es
	int	224			; call the BDOS
	pop	es

	pop	bp
	ret	4

__SUPIF:
;-------
	cmp	_ostype,1		; CDOS 5.x?
	 je	__BDOS			; yes, can use int 224
					; else use special entry
	push	bp
	mov	bp,sp
	pushx	<cx, dx>

	mov	cl,6[bp]		; get BDOS function number
	mov	dx,4[bp]		; get BDOS parameter
	call	dword ptr bdose		; call the BDOS

	popx	<dx, cx>
	pop	bp
	ret	4

V386_CHK:	; return DX:AX -> page table if 386, (BYTE FAR *)0 if XM
;--------
	mov	cl,154			; get SYSTEM data segment
	int	224			; ES:BX -> SYSDAT
	sub	dx,dx			; assume no page table
	cmp	_ostype,2		; is this CDOS 6.x (or 2.0)
	 jb	v386_false		; skip if earlier OS
	mov	bx,es:0C8h[bx]		; get 386 data pointer
	test	bx,bx			; test if 386 system
	 jz	v386_false		; skip if no 386 info
	test	es:word ptr 14[bx],1	; verify protected mode
	 jz	v386_false		; skip if smart XM system
	mov	dx,es:12[bx]		; else get page table segment
v386_false:
	push	ds
	pop	es			; ES = DS = local data
	sub	ax,ax			; set an offset of 0
	ret

V386_PTR:	; return DX:AX = linear memory address
;--------
;	Note:	This is only called if V386_CHK succeeds!

	pushx	<es, di>
	mov	cl,154			; get SYSTEM data segment
	int	224			; ES:BX -> SYSDAT
	mov	bx,es:0C8h[bx]		; get 386 data pointer
	mov	cx,es:10[bx]		; get NPAGES value
	mov	es,es:8[bx]		; get MP_TABLE segment
	sub	ax,ax			; assume failure
	mov	di,64*2			; point to beyond 1st Mb
	sub	cx,64			; subtract size of 1st Mb
	 jbe	v386_ptr_done		; skip if memory size <= 1 Mb (silly!)
	repne	scasw			; find block of 0000 (free memory)
	 jne	v386_ptr_done		; skip if all allocated (silly!)
	decx	<di, di>		; ES:DI -> word of 0000
	dec	ax			; AX = 0FFFFh
	stosw				; mark block as allocated
	mov	ax,di			; AX = offset in table + 2
	shr	ax,1			; halve the offset
	dec	ax			; adjust for STOSW, AX = index now
v386_ptr_done:				; AX = 0000 or free block index
	popx	<di, es>
	ret

IO_MEM_ALLOC:
;------------
	push	bp
	mov	bp,sp
	pushx	<si, di, ds, es>

	mov	cl,154			; get SYSDAT address
	int	224			; ES:BX -> SYSDAT
	mov	ax,es
	mov	ds,ax			; DS -> SYSDAT
	mov	ax,46			; IO_MEM_ALLOC function
	mov	dx,6[bp]		; DX = # of paragraphs
	mov	cx,4[bp]		; CX = align mask
	call	dword ptr ds:[28h]	; call the XIOS
					; AX = new segment
	popx	<es, ds, di, si>
	pop	bp
	ret	4

INSERT_MFL:	; release memory block for use by IO_MEM_ALLOC
;----------
	push	bp
	mov	bp,sp
	pushx	<si, es>

	mov	cl,154			; get SYSDAT address
	int	224			; ES:BX -> SYSDAT

	cli				; stop dispatches (just in case...)
	mov	si,es:MDUL[bx]		; SI -> unused MD
	test	si,si			; do we have any?
	 jz	insert_done		; no, can't do this then
	mov	ax,es:[si]		; get other entries on list
	mov	es:MDUL[bx],ax		; leave them on list
	mov	ax,6[bp]		; get base paragraph
	mov	es:2[si],ax		; store in MD for XIOS_MFL
	mov	ax,4[bp]		; get # of paragraphs
	mov	es:4[si],ax		; store in MD for XIOS_MFL

	mov	ax,es:XIOS_MFL[bx]	; get XIOS_MFL root entry
	mov	es:[si],ax		; append to us
	mov	es:XIOS_MFL[bx],si	; make us XIOS_MFL root entry

insert_done:
	sti				; allow other processes in

	popx	<es, si>
	pop	bp
	ret	4

FLAGSET:
;-------
	push	bp
	mov	bp,sp
	pushx	<si, di, es, ds>
	cmp	sysdat,0
	 je	flagset_ret
	mov	dx,4[bp]		; get flag number
	cmp	_ostype,0		; is this DOS Plus?
	mov	ds,sysdat		; DS -> SYSDAT
	 je	flagset_plus		; skip if DOS Plus
	mov	cx,133			; CDOS DEV_FLAGSET function
	call	ds:dword ptr [0]	; call via SUPERVISOR
	jmps	flagset_ret		; common exit code
flagset_plus:
	call	ds:dword ptr [38H]	; call DOS PLus int_flagset vector
flagset_ret:
	popx	<ds, es, di, si>
	pop	bp
	ret	2			; pop of flag number, return


MKPTR:
;-----
	push	bp
	mov	bp,sp
	mov	ax,6[bp]
	mov	dx,4[bp]
	pop	bp
	ret	4

FARMOVE:
;-------
	push	bp
	mov	bp,sp
	pushx	<ds, si, es, di>

	mov	cx,4[bp]		; get count
	les	di,6[bp]		; get destination
	lds	si,10[bp]		; get source
	shr	cx,1			; convert to words
	 jnc	farmov1			; skip if even number
	movsb				; else move odd byte first
farmov1:
	rep	movsw			; move complete words

	popx	<di, es, si, ds>
	pop	bp
	ret	2*dword+word		; remove parameters

MEMSET:
;------
	push	bp
	mov	bp,sp
	push	di

	push	ds
	pop	es			; ES = local data segment

	mov	cx,4[bp]		; CX = byte count
	mov	al,6[bp]		; AL = fill byte
	mov	di,8[bp]		; ES:DI -> buffer pointer
	shr	cx,1			; convert to words
	mov	ah,al			; AL = AH = pattern for word fill
	rep	stosw			; fill with words first
	 jnc	memset1			; skip if even byte count
	stosb				; else do last odd one
memset1:				; memory block filled
	pop	di
	pop	bp
	ret	3*word

page
INT_INIT:
;--------
	push	bp
	mov	bp,sp
	mov	cl,154			; CL = S_SYSDAT function
	int	224			; ES:BX -> SYSDAT
	mov	bx,38H			; assume CDOS interrupt dispatcher
	cmp	_ostype,0		; is this DOS Plus?
	 jne	int_init_cdos		; skip CDOS 5.x or CDOS 6.x
	mov	bx,34h			; use DOS Plus interrupt dispatcher
int_init_cdos:
	cli				;; stop interrupts for a moment
	mov	ax,es:[bx]		;; get offset of dispatcher
	mov	disp_off,ax
	mov	ax,es:2[bx]		;; get segment of dispatcher
	mov	disp_seg,ax
	push	ds
	pop	es			;; ES = DS = local data segment

	push	ds
	sub	ax,ax
	mov	ds,ax			;; DS -> int vectors
	mov	bx,4[bp]		;; BX = IRQ number
	shl	bx,1
	shl	bx,1			;; BX = offset in vector table
	mov	ax,offset i_com
	mov	0[bx],ax
	mov	2[bx],cs		;; take over hardware interrupt
	mov	bx,(INT_OFF+TMR_LVL)*dword
	mov	ax,0[bx]		;; get original vector for chaining
	mov	i_tmr_off,ax		;; save offset of old timer
	mov	ax,2[bx]
	mov	i_tmr_seg,ax		;; save segment of new timer
	mov	ax,offset i_timer
	mov	0[bx],ax		;; set address of our timer code
	mov	2[bx],cs
	pop	ds
	sti				; allow interrupts again

	pop	bp
	ret	2


page
	Assume	DS:Nothing, SS:Nothing	; DS, SS are undefined
	even
;=====
i_com:		; network hardware interrupt
;=====
	cli
	cld
	push	ds
	mov	ds,niosds		; DS = NIOS data segment

	Assume	DS:DGROUP, SS:DGROUP	; DS may now be used safely

	mov	com_ss,ss
	mov	com_sp,sp		; save current stack
	mov	ss,niosds
	mov	sp,offset nios_stack	; swap to new stack
	pushx	<ax, bx, cx, dx>
	pushx	<si, di, bp, es>

	call	COM_INT			; call Turbo C hardware int handler

	popx	<es, bp, di, si>
	popx	<dx, cx, bx, ax>
	mov	ss,com_ss		; restore user stack
	mov	sp,com_sp
	mov	ds,sysdat		; DS -> SYSDAT
	cmp	drl,0000h		; cause dispatch if woke up a process
	pop	ds
	 jz	i_com_iret		; jump to IRET instruction
	Assume	DS:Nothing, SS:Nothing	; DS, SS are undefined here
i_com_disp:
	jmp	disp_addr		; jump to dispatcher entry
i_com_iret:
	iret				; else return from interrupt

page
	Assume	DS:Nothing, SS:Nothing	; DS, SS are undefined here
	even
;=======
i_timer:
;=======
	cli
	cld
	push	ds
	mov	ds,niosds		; DS = NIOS data segment

	Assume	DS:DGROUP, SS:DGROUP	; DS may now be used safely

	mov	com_ss,ss
	mov	com_sp,sp		; save current stack
	mov	ss,niosds
	mov	sp,offset nios_stack	; swap to new stack
	pushx	<ax, bx, cx, dx>
	pushx	<si, di, bp, es>

	call	TMR_INT			; call Turbo C hardware int handler

	popx	<es, bp, di, si>
	popx	<dx, cx, bx, ax>
	mov	ss,com_ss		; restore user stack
	mov	sp,com_sp
	pop	ds
	Assume	DS:Nothing, SS:Nothing	; DS, SS are undefined here
	jmp	i_tmr_ptr		; chain to normal timer

page
	Assume	DS:DGROUP, SS:DGROUP	; DS, SS are normal here

STACK_SIZE	equ	256		; # of levels
ENV_DS		equ	word ptr 0
ENV_SP		equ	word ptr 2
ENV_SS		equ	word ptr 4
ENV_BOTTOM	equ	word ptr 6
ENV_STACK	equ	ENV_BOTTOM + STACK_SIZE*word

stack_swap:
;----------
;	entry:	DS:DX -> LDCB
;
;	This function swaps to a local line driver stack
;	and doesn't return the normal way -- study it carefully!

	pop	di
	mov	bx,dx			; BX -> LDCB
	mov	bl,[bx]			; get line driver number
	mov	bh,0			; BX = line driver #
	shl	bx,1			; make it a word index
	mov	ax,ds			; AX = parameter segment
	mov	ds,niosds
	mov	bx,env_tab[bx]		; DS:BX -> line driver environment
	mov	ENV_DS[bx],ax		; save parameter segment
	mov	ENV_SS[bx],ss
	mov	ENV_SP[bx],sp		; save entry stack
	mov	ax,ds
	mov	es,ax			; ES = local NIOS data
	cli
	mov	ss,ax			;; SS:SP -> local stack
	lea	sp,ENV_STACK[bx]
	sti

	mov	ax,dx			; AX = offset of parameter block
	mov	dx,ENV_DS[bx]		; DX:AX -> parameter block
	push	bx			; save environment
	call	di			; call the I/O routine
	pop	bx			; restore environment

	cli				;; swap back to user stack
	mov	ss,ENV_SS[bx]
	mov	sp,ENV_SP[bx]
	sti
	mov	ds,ENV_DS[bx]		; restore user parameter segment
	retf				; AX = return code

page
;-----
ninit:
;-----
	mov	cx,dx
	mov	dx,ds			; DX:CX -> entry parameter

	push	ds			; save our data segment
	mov	ds,niosds		; AX = local data

	pushx	<dx, cx>		; save parameter pointer
	mov	cl,154			; CDOS S_SYSDAT function
	int	224			; get sysdat address
	mov	sysdat,es		;     for use by ISRs
	popx	<cx, dx>		; restore parameter pointer

	mov	bx,offset env0		; use 1st environment for NINIT
	mov	ENV_SS[bx],ss
	mov	ENV_SP[bx],sp
	mov	ax,ds
	mov	es,ax			; ES = local data segment
	cli
	mov	ss,ax			;; SS:SP -> local stack
	lea	sp,ENV_STACK[bx]	;; (ints disabled for old 8088's)
	sti

	pushx	<dx, cx>		; push parameter pointer
	call	NINIT			; call Turbo C code

	mov	bx,offset env0		; BX -> local stack structure
	cli
	mov	ss,ENV_SS[bx]
	mov	sp,ENV_SP[bx]
	sti
	pop	ds			; DS = entry segment
	retf				; return to NDOS initialization


nout:			; Line driver output select routine
;----
	mov	bx,dx
	mov	RCB_LDNUM[bx],NUM_I_LDCB
	sub	ax,ax
	retf

nin:			; DOS Plus driver input select
;---
	mov	bx,dx
	mov	RCB_LDNUM[bx],0
	sub	ax,ax
	retf

;----
null:			; Not currently used
;----
	retf

;--------
xin_init:		; network init pointer, called via LDCB
;--------
	call	stack_swap		; kludge the stack

	call	XIN_INIT		; call Turbo C function

	ret				; unkludge the stack (see stack_swap)


;---
xin:			; receive message, called via LDCB
;---
	call	stack_swap		; kludge the stack

	push	ax			; push LDCB offset in NIOS DSEG
	call	XIN			; call Turbo C function

	ret				; unkludge the stack (see stack_swap)


;-------
xin_err:		; no special error recovery
;-------
	sub	ax,ax
	retf


;---------
xout_init:		; init
;---------
	sub	ax,ax
	retf


;----
xout:			; output routine, called via LDCB pointer
;----
	call	stack_swap		; kludge the stack

	push	ax			; push LDCB offset in NIOS DSEG
	call	XOUT			; call Turbo C function

	ret				; unkludge the stack (see stack_swap)


;--------
xout_err:		;error recovery
;--------
	sub	ax,ax
	retf


LXLSH@:					; Turbo C library function clone
;------					; Warning:  CALLF'ed!
;	entry:	DX:AX = long word
;		CL = shift count
;	exit:	DX:AX = shifted value

	mov	ch,0			; make shift a word for LOOP
	jcxz	lxlsh_ret		; skip if not shifting at all
lxlsh_loop:
	shl	ax,1			; shift low word (MSB drops into carry)
	rcl	dx,1			; shift high word (rotate in carry)
	loop	lxlsh_loop		; repeat shift CX times
lxlsh_ret:
	retf				; return to caller

_TEXT	ends

_DATA	segment	public word 'DATA'
	extrn	_ostype:byte		; 0=DOS Plus, 1=CDOS 5.x, 2=CDOS 6.x

	public	_dl_tmt

	org	0000h
	public	_pnid
_pnid	db	255 dup (?)		; physical node ID's entered here

	org	0100h			; skip CMD-like base page
niosdat	label	dword
	dd	nout			; Line driver output select routine
	dd	nin			; DOS Plus driver input select
	dd	null			; Not currently used
	dd	null
	dd	null
	dd	ninit			; NIOS initialization
bdose   dd	null			; bdos entry vector
signon  dw	0,0			; leave DR Net signon message


;	Line Driver Control Blocks

	db	0			; ldcb #0
	db	0			; status
	db	0			; input driver
	dw	?			; current buffer size
	dd	?			; message pointer
_dl_tmt	dd	xin_init		; network init pointer
	dd      xin			; rcvmsg driver
	dd      xin_err			; error recovery

if NUM_I_LDCB gt 1
	db	1			; ldcb #1 (CDOS only)
	db	0			; status
	db	0			; input driver
	dw	?			; current buffer size
	dd	?			; message pointer
	dd	xin_init		; network init pointer
	dd      xin			; rcvmsg driver
	dd      xin_err			; error recovery
endif

	db	NUM_I_LDCB		; ldcb #2 (output)
	db	0			; status
	db	1			; output line driver
	dw	?			; current buffer size
	dd	?			; message pointer
	dd	xout_init		; init
	dd	xout			; send driver
	dd	xout_err		; error recovery

	even				; re-align on a word boundary

; LAN status report area
;-----------------------

	public	_err			; error information for ARCSTAT

_err		label	word		; must be at 014A in data segment
		dw	0		; transmit error count
		dw	15 dup (0)	; RETRY counters -
		dw	0		; receive error counter
		dw	0		; transport timeout counter
		dw	0		; dos plus session timeout counter
		dw	0		; reconfiguration counter
		dw	0		; no tx buffers counter
		dw	0		; no rx buffers counter
		dw	0		; datalink tx timeout counter
		dw	0		; abort tx timeout counter
		dw	0		; rx disabled counter
		dw	0		; Power On Reset Counter <2.14>


;	Note: Number of environments must match number of line drivers!

env_tab		dw	DGROUP:env0, DGROUP:env1, DGROUP:env2

env0		dw	3 dup (0)
		dw	STACK_SIZE dup (0cccch)

env1		dw	3 dup (0)
		dw	STACK_SIZE dup (0cccch)

env2		dw	3 dup (0)
		dw	STACK_SIZE dup (0cccch)

		dw	STACK_SIZE dup (0cccch)	; local stack for NIOS ints
nios_stack	dw	?
com_sp		dw	?		; save user stack during hw int
com_ss		dw	?

sysdat		dw	0

_DATA		ends

	end
